# $Id: 1Dmodel.R,v 1.4 2017/08/16 15:10:07 stefan Exp stefan $
 
# Supplement of: 
# Gas-Chromatography using ice coated fused silica-columns: Study of adsorption of sulfur dioxide on water-ice
#
# Simulation of adsorption on the solid phase

source("simul_parameters.R")

# 1D-Simulation
peak.model <- function(time, y, parms) {
	with(as.list(parms), {
	   v = l / voidTime
		transport <- tran.1D(C=y,
			flux.up=v*xSO2*ifelse(peak==TRUE,CGauss(time - voidTime,sigma),Phi(time - voidTime,sigma)),
			v=v,
			D=Da,
			dx=grid)
		dy <- transport$dC/(1 + kapazv(y,parms))
		return <- list(dy, xSO2out=y[Nz])
	})
}

pdf(file="1Dmodel.pdf",width=width,height=height,family=family,pointsize=pointsize)
par(mai=mai,mar=mar)
grid <- setup.grid.1D(L=p$l, N=p$Nz)
times <- seq(0, p$tmax, by=(p$tmax/p$points))
xSO2ini <- rep(0, length.out=p$Nz)
out <- ode.1D(func=peak.model, y=xSO2ini, parms=parameters, times=times, nspec=1)
tnetto <- times - 2 * p$voidTime	
dfout <- data.frame(out)
plot(tnetto,dfout$xSO2out, type="l",xlim=c(-3,40),
  xlab="adjusted retention time / [s]", 
  ylab=expression(paste(italic(x), "(", SO[2], ") / ppm")))

parameters["xSO2"] <- 20
xSO2ini <- rep(0, length.out=p$Nz)
out <- ode.1D(func=peak.model, y=xSO2ini, parms=parameters, times=times, nspec=1)
dfout <- data.frame(out)
lines(tnetto,dfout$xSO2out, type="l",new=FALSE)

parameters["xSO2"] <- 15
xSO2ini <- rep(0, length.out=p$Nz)
out <- ode.1D(func=peak.model, y=xSO2ini, parms=parameters, times=times, nspec=1)
dfout <- data.frame(out)
lines(tnetto,dfout$xSO2out, type="l",new=FALSE)

parameters["xSO2"] <- 10
xSO2ini <- rep(0, length.out=p$Nz)
out <- ode.1D(func=peak.model, y=xSO2ini, parms=parameters, times=times, nspec=1)
dfout <- data.frame(out)
lines(tnetto,dfout$xSO2out, type="l",new=FALSE)

parameters["xSO2"] <- 13
xSO2ini <- rep(0, length.out=p$Nz)
out <- ode.1D(func=peak.model, y=xSO2ini, parms=parameters, times=times, nspec=1)
dfout <- data.frame(out)
lines(tnetto,dfout$xSO2out, type="l",new=FALSE)

parameters["xSO2"] <- 7
xSO2ini <- rep(0, length.out=p$Nz)
out <- ode.1D(func=peak.model, y=xSO2ini, parms=parameters, times=times, nspec=1)
dfout <- data.frame(out)
lines(tnetto,dfout$xSO2out, type="l",new=FALSE)

# position of peak maxima
t <- seq(p$tmax/40, p$tmax, by=(p$tmax/40))
lines(t,invkapaz(t,parameters),lty=3,col="blue",lwd=2)
dev.off()
