#! /bin/csh -f

#$ -N cd24.ov.m
#$ -cwd
#$ -V
#$ -m ea
#$ -M daniel.neumann@hzg.de

# ====================== CCTMv5.0.1 Run Script ====================== #
# Usage: run.cctm >&! cctm_V5.log &                                   #
# The following environment variables must be set for this script to  #
# execute properly:                                                   #
#   setenv M3DATA =  input/output data directory                      #
# To report problems or request help with this script/program:        #
#             http://www.cmascenter.org/html/help.html                #
# =================================================================== #
 
#> Source the config.cmaq file to set the run environment

 set M3HOME  = /data/M3HOME/CMAQ/std_5.0.1_seasalt/CMAQv5.0.1
 set M3LIB   = ${M3HOME}/lib
 set M3MODEL = ${M3HOME}/models
 set M3DATA  = ${M3HOME}/data
 source ${M3HOME}/scripts/config.cmaq

#> Check that M3DATA is set:
 if ( ! -e $M3DATA ) then
    echo "   $M3DATA path does not exist"
    exit 1
    endif
 echo " "; echo " Input data path, M3DATA set to $M3DATA"; echo " "

 set YAMO       = Y	# N = use WRF advection scheme / Y = use YAMO advection scheme

#set MECH       = cb05cl_ae5_aq		# CMAQ 4.7.1 compatibility mechanism
 set MECH       = cb05tucl_ae5_aq	# KBT default mechanism
#set MECH       = cb05tucl_ae6_aq	#
#set MECH       = cb05tump_ae6_aq	# multi-pollutant mechanism
#set MECH	= cbtuclhg_ae5_aq_ros3	# rosenbrock solver based mercury mechanism - NOT AVAILABLE YET

 set GRID_NAME  = CD24			# grid name
 set grid_name  = cd24			# lower case grid name

 set APPL       = effectSeaSalt.v5.ov13.mode		# Application name mainly to distinguish different emission scenarios
#set APPL       = cb05tucl_ae5_aq_seasalt	# Application name mainly to distinguish different emission scenarios
#set APPL       = cb05tucl_ae5_aq_ssa
#set APPL       = cb05tucl_ae5_aq
#set APPL       = NOSHPI_REF
#set APPL       = 2030_ECA_SCEN1
#set APPL	= 2030_ECA_SCEN2
#set APPL	= 2030_ECA_SCEN3

 set RESTART    = Y     # N = use profile ICON / Y = use CONC as ICON
 set IC_PROFILE = Y     # Y = use profile ICON even if ( ${NEST} == "Y" ) instead of m3conc ICON

 set NEST       = Y     # N = use profile BCON / Y = use BCON/ICON from CCTM CONC file

 set USER_BC    = Y     # N = use ${NEST} to determine BCON file / Y = use user defined BC
#set BC_PATH_USER = /storage/M3HOME/data/bcon/${grid_name}/2013/  	# ONLY if ( ${GLOBAL_BC} == "Y" )
 set BC_PATH_USER = /storage/neumannd/data/bcon/${GRID_NAME}/${APPL}/
#set BC_FILE_USER = BCON_47cb05_HG_CD72_g_  	# ONLY if ( ${GLOBAL_BC} == "Y" )
 set BC_FILE_USER = BCON_${APPL}_${GRID_NAME}_

#set EMIS_PATH    = /data/bieser/smoke_res/v1.1/${GRID_NAME}/merge/cb5/${APPL}
#set EMIS_PATH    = /storage/bieser/smoke_res/v1.1/CD72/merge/cb5/CLM/CD72_ALL/
#set EMIS_PATH    = /storage/bieser/smoke_res/CNSS/CD24/2013/
#set EMIS_PATH    = /storage/bieser/smoke_res/ANNA/EMEP
 set EMIS_PATH    = /storage/neumannd/data/emis/CD24/cb05_ANNA.EMEP
#set EMIS_FILE    = EURODELTA/EMIS_E{APPL}_${GRID_NAME}    	# date is appended in daily loop
#set EMIS_FILE    = /egts_l.cd72.cb5_A4.P.B3_CD72_ALL.
#set EMIS_FILE    = /egts_CD24_ARMIN_CNSS_BASE_CASE.
 set EMIS_FILE    = /ANNA.EMEP.cb05.


#set STDATE       = 2007352	# beginning date
#set STDATE       = 2008061	# beginning date
 set STDATE       = 2008253	# beginning date
#set STDATE       = 2008243	# beginning date
#set STDATE       = 2008138	# beginning date
#set STDATE       = 2008176	# beginning date
#set ENDATE       = 2007366		# end date (including)
#set ENDATE       = 2008045		# end date (including)
#set ENDATE       = ${STDATE}
 set ENDATE       = 2008274
#set ENDATE       = 2007352		# end date (including)
#set ENDATE       = 2008091		# end date (including)
#set ENDATE       = 2008100

#> horizontal domain decomposition
 set SERIAL_RUN = N     # Y = set NPCOL, NPROW, NPROCS = 1 (use qlogin) / N user defined parallel run (use qsub)
 set MANUAL_RUN = N	# manually set NPCOL NPROW NPROCS
			# unfortunately -pe orte needs to be set manually
#$ -pe orte 240

 if ( ${MANUAL_RUN} == "N" ) then
   if ( ${GRID_NAME} == "AQ24" ) then
     setenv NPCOL_NPROW "25 12"; set NPROCS   = 300 ## AQ24 - EUROPE
    #setenv NPCOL_NPROW "22 15"; set NPROCS   = 330 ## AQ24 - EUROPE
   else if ( ${GRID_NAME} == "CD24" ) then
    #setenv NPCOL_NPROW "10 11"; set NPROCS   = 110 
    #setenv NPCOL_NPROW "10 18"; set NPROCS   = 180 # CD24 - NSBS
    #setenv NPCOL_NPROW "14 17"; set NPROCS   = 238
     setenv NPCOL_NPROW "15 16"; set NPROCS   = 240
    #setenv NPCOL_NPROW "23 11"; set NPROCS   = 253 # CD24 - NSBS
   else if ( ${GRID_NAME} == "CD72" ) then
    #setenv NPCOL_NPROW " 8  5"; set NPROCS   =  40 # CD72 - EUROPE
    #setenv NPCOL_NPROW " 9  7"; set NPROCS   =  63 # CD72 - EUROPE
    #setenv NPCOL_NPROW " 6  5"; set NPROCS   =  30 # CD72 - EUROPE
    #setenv NPCOL_NPROW "12 10"; set NPROCS   = 120 # CD72 - EUROPE
    #setenv NPCOL_NPROW "10  9"; set NPROCS   =  90 # CD72 - EUROPE
     setenv NPCOL_NPROW "12 11"; set NPROCS   = 132 # CD72 - EUROPE
    #setenv NPCOL_NPROW "15 14"; set NPROCS   = 210 # CD72
   else if ( ${GRID_NAME} == "CD06" ) then
    #setenv NPCOL_NPROW "16 16"; set NPROCS   = 256 # CD06 - NS
     setenv NPCOL_NPROW "18 18"; set NPROCS   = 324 # CD06 - NS
    #setenv NPCOL_NPROW "20 20"; set NPROCS   = 400 # CD06 - NS
   endif
 else
   setenv NPCOL_NPROW "20 10"; set NPROCS   = 200	# set this if ( ${MANUAL_RUN} == "Y" )
  #setenv NPCOL_NPROW "10 10"; set NPROCS   = 100
 endif

###########################
### END OF USER SECTION ###
###########################

#############################
### ADVANCED USER SECTION ###
#############################

 if ( ${YAMO} == "N" ) then
#  set CFG     = ${MECH}
#  set CFG     = ${MECH}_std
#  set CFG     = ${MECH}_seasalt
   set CFG     = ${MECH}_ssa
 else if ( ${YAMO} == "Y" ) then
#  set CFG     = yamo_${MECH}
#  set CFG     = ${MECH}_std
#  set CFG     = ${MECH}_seasalt
   set CFG     = ${MECH}_ssa
 endif

 set EXEC      = CCTM_${CFG}_$EXECID

#> Set the working directory:
 set BASE     = ${M3HOME}/scripts/cctm/
 set BLD      = ${BASE}/BLD_${CFG}

 cd $BASE; date; cat $BASE/cfg.${APPL}; echo "    "; set echo

#> timestep run parameters

#set STDATE   = 2008001       # beginning date
#set ENDATE   = 2008001       # end date (including)
 set STTIME   = 000000        # beginning GMT time (HHMMSS)
 set NSTEPS   = 240000        # time duration (HHMMSS) for this run
 set TSTEP    = 010000        # output time step interval (HHMMSS)

 set YR    = 00	# not used
 set MONTH = 00	# not used
 set DAY   = 00	# not used

#> set log file [ default = unit 6 ]; uncomment to write standard output to a log
#setenv LOGFILE $BASE/$APPL.log

#> horizontal grid defn; check GRIDDESC file for GRID_NAME options
 setenv GRIDDESC /data/M3HOME/GRIDDESC1
 setenv GRID_NAME ${GRID_NAME}

#> species for standard conc
#setenv CONC_SPCS "O3 NO ANO3I ANO3J NO2 FORM ISOP ANH4J ASO4I ASO4J"

#> layer range for standard conc
#setenv CONC_BLEV_ELEV " 1 4"

#> species for integral average conc
#setenv AVG_CONC_SPCS "O3 NO CO NO2 ASO4I ASO4J NH3"
#setenv AVG_CONC_SPCS "ALL"
 setenv AVG_CONC_SPCS "NO NO2"

#> layer range for integral average conc
 setenv ACONC_BLEV_ELEV " 1  1"

#> override default beginning time average conc timestamp [ N|F ]
#setenv ACONC_END_TIME Y

#> max sync time step (sec) [720]
#setenv CTM_MAXSYNC 300
 
#> min sync time step (sec) [60]
#setenv CTM_MINSYNC 01

#> cksum report [ Y|T ]
#setenv CTM_CKSUM N

#> cloud diagnostic file [ N|F ]
 setenv CLD_DIAG Y

#> aerosol diagnostic file [ N|F ]
 setenv CTM_AERDIAG Y

#> photolysis diagnostic file [ N|F ]
#setenv CTM_PHOTDIAG Y

#> sea-salt emissions diagnostic file [ N|F ]
 setenv CTM_SSEMDIAG Y

# START NEUMANND
#> read sea-salt emissions from external file [ N|F ]
 setenv CTM_READSSEMIS Y
# END NEUMANND

#> windblown dust? [ Y|T ]
# setenv CTM_WB_DUST Y
 setenv CTM_WB_DUST N

#> use agricultural activity for windblown dust? [ N|F ]
#> - env var ignored if CTM_WB_DUST is N|F
# setenv CTM_ERODE_AGLAND Y
 setenv CTM_ERODE_AGLAND N

#> windblown dust emissions diagnostic file [ N|F ]
#> - env var ignored if CTM_WB_DUST is N|F
# setenv CTM_DUSTEM_DIAG Y
 setenv CTM_DUSTEM_DIAG N

#> turn on lightning NOx [ N|F ]
# setenv CTM_LTNG_NO Y
 setenv CTM_LTNG_NO N

#> save derived vertical velocity component to conc file [ N|F ]
 setenv CTM_WVEL Y

#> use Min Kz option in edyintb [Y], otherwise revert to Kz0UT
#setenv KZMIN Y

#> inline deposition velocities [ Y|T ]
# setenv CTM_ILDEPV Y
 setenv CTM_ILDEPV N

#> landuse specific deposition velocities [ N|F ] 
 setenv CTM_MOSAIC N

#> Ammonia bi-directional flux for inline deposition velocities [ N|F ]
#> - env var ignored if CTM_ILDEPV is N|F
 setenv CTM_ABFLUX N

#> Mercury bi-directional flux for inline deposition velocities [ N|F ]
#> - env var ignored if CTM_ILDEPV is N|F
 setenv CTM_HGBIDI N

#> Surface HONO interaction [ Y|T ]
#> - env var ignored if CTM_ILDEPV is N|F
 setenv CTM_SFC_HONO Y

#> diagnostic file for deposition velocities [ N|F ]
 setenv CTM_DEPV_FILE N 

#> use in-line biogenic emissions [ N|F ]
# setenv CTM_BIOGEMIS Y
 setenv CTM_BIOGEMIS N

#> use in-line plume rise emissions [ N|F ]
# setenv CTM_PT3DEMIS Y
 setenv CTM_PT3DEMIS N

#> turn off excess WRITE3 logging
 setenv IOAPI_LOG_WRITE F

#> stop on inconsistent input file [ T | Y | F | N ]
 setenv FL_ERR_STOP F

#> turn off I/O-API PROMPT*FILE interactive mode
 setenv PROMPTFLAG F

#> support needed for large timestep records (>2GB/timestep record) [ NO ]
 setenv IOAPI_OFFSET_64 NO 

#> define the model execution id
 setenv EXECUTION_ID $EXEC

#> remove existing output files?
 set DISP = delete
#set DISP = update
#set DISP = keep

#################################
### END ADVANCED USER SECTION ###
#################################

 while ( ${STDATE} <= ${ENDATE} )

 set YEAR = ${STDATE}
 @ YEAR = ${YEAR} / 1000
 set JDAY = ${STDATE}
 @ JDAY = ${STDATE} - 1000 * ${YEAR}

 if ( ${YEAR} % 4 == 0 ) then
   if ( ${JDAY} > 366 ) then
     @ YEAR = ${YEAR} + 1
     @ STDATE = 1000 * ${YEAR} + 1
   endif
 else
   if ( ${JDAY} > 365 ) then
     @ YEAR = ${YEAR} + 1
     @ STDATE = 1000 * ${YEAR} + 1
   endif
 endif

#> output files and directories
#set OUTDIR    = /storage/neumannd/data/cctm/${GRID_NAME}/seasalt3d.${APPL}
#set OUTDIR    = /storage/neumannd/data/cctm/${GRID_NAME}/seasalt3d.base
#set OUTDIR    = /storage/neumannd/data/cctm/${GRID_NAME}/seasalt3d.compare
#set OUTDIR    = /storage/neumannd/data/cctm/${GRID_NAME}/seasalt3d.noSurf
#set OUTDIR    = /storage/neumannd/data/cctm/${GRID_NAME}/seasalt3d.noSalt
# set OUTDIR   = /data/bieser/cmaq_res/new/CD24/ECA_2000
# set OUTDIR   = $M3DATA/cctm/${GRID_NAME}/${APPL}/${CFG}
# set OUTDIR    = /scratch/bieser/cctm/${GRID_NAME}/${APPL}/${CFG}
  set OUTDIR = /storage/neumannd/data/cctm/${GRID_NAME}/${APPL}
 if ( ! -d "$OUTDIR" ) mkdir -p $OUTDIR

#> inputs

#> species defn & photolysis
 setenv gc_matrix_nml ${BLD}/GC_$MECH.nml
 setenv ae_matrix_nml ${BLD}/AE_$MECH.nml
 setenv nr_matrix_nml ${BLD}/NR_$MECH.nml
 setenv tr_matrix_nml ${BLD}/Species_Table_TR_0.nml
 setenv CSQY_DATA ${BLD}/CSQY_DATA_$MECH
 if (! (-e $CSQY_DATA ) ) then
           echo " $CSQY_DATA  not found "
           exit 1
           endif

#> mulit day loop
 set SDATE = ${STDATE}

#> inline biogenic emissions processing
 if ( $?CTM_BIOGEMIS ) then   # $CTM_BIOGEMIS is defined
    if ( $CTM_BIOGEMIS == 'Y' || $CTM_BIOGEMIS == 'T' ) then
       set biogon = 1
    else
       set biogon = 0
    endif
 else   # $CTM_BIOGEMIS is not defined => $CTM_BIOGEMIS == 'Y'
    set biogon = 1
 endif
 if ( $biogon ) then
    set GSPROpath = /storage/bieser/smoke_res/v1.1/CD72/biog/
    setenv GSPRO $GSPROpath/spro_aero6.txt
    set IN_BEISpath = /storage/bieser/smoke_res/v1.1/CD72/biog/
    setenv B3GRD     $IN_BEISpath/b3grd_beis3.14.cd72.cd72.ncf
    setenv BIOSEASON $IN_BEISpath/bioseason.${YEAR}.cd72.ncf
    setenv BIOG_SPRO     B10C5 # speciation profile to use for biogenics
    setenv BIOSW_YN      Y     # use frost date switch [Y|T]
    setenv SUMMER_YN     Y     # Use summer normalized emissions? [Y|T]
#   setenv PX_VERSION    Y     # MCIP is PX version? [N|F]
#> beis mass emissions diagnostic file [N|F] ]
    setenv B3GTS_DIAG N
    setenv YMD ${YEAR}${MONTH}${DAY}
    setenv INITIAL_RUN Y # non-existent or not using SOILINP [N|F]; default uses SOILINP
#   setenv SOILINP $OUTDIR/$EXEC"_SOILINP".${YEAR}${MONTH}${DAY}  # Biogenic NO soil input file
 endif

#if ( $DISP == 'delete' && $biogon ) then
#   rm -f $B3GTS_S $SOILOUT
#endif

 if ( $?CTM_PT3DEMIS ) then   # $CTM_PT3DEMIS is defined
    if ( $CTM_PT3DEMIS == 'Y' || $CTM_PT3DEMIS == 'T' ) then
       set pt3don = 1
    else
       set pt3don = 0
    endif
 else   # $CTM_PT3DEMIS is not defined => $CTM_PT3DEMIS == 'N'
    set pt3don = 0
 endif

 set OCEANpath = /storage/M3HOME/data/ocean/sf050m_GIS
#set OCEANpath = /storage/M3HOME/data/ocean/sf000m_GIS
#set OCEANpath = /storage/M3HOME/data/ocean/mixed_GIS
 set OCEANfile = OCEAN_${GRID_NAME}_sf050m_GIS_ubound_sal.nc
#set OCEANfile = OCEAN_${GRID_NAME}_sf000m_GIS_ubound_sal.nc
#set OCEANfile = OCEAN_${GRID_NAME}_noSalt_GIS.nc
 setenv OCEAN_1 ${OCEANpath}/${OCEANfile}

 if ( $?CTM_ERODE_AGLAND ) then   # $CTM_ERODE_AGLAND is defined
    if ( $CTM_ERODE_AGLAND == 'Y' || $CTM_ERODE_AGLAND == 'T' ) then
       set aglandon = 1
    else
       set aglandon = 0
    endif
 else   # $CTM_ERODE_AGLAND is not defined => $CTM_ERODE_AGLAND == 'N'
    set aglandon = 0
 endif

 if ( $aglandon ) then
    setenv CROPMAP01 ${M3DATA}/crop/BeginPlanting_12km_CMAQ-BENCHMARK
    setenv CROPMAP04 ${M3DATA}/crop/EndPlanting_12km_CMAQ-BENCHMARK
    setenv CROPMAP08 ${M3DATA}/crop/EndHarvesting_12km_CMAQ-BENCHMARK
 endif

 set COT = ${M3DATA}/dust
 setenv DUST_LU_1 /data/bieser/newSMOKE/data/inventory/${grid_name}/biog/LANDUSE_${grid_name}.nc 
 setenv DUST_LU_2 /data/bieser/newSMOKE/data/inventory/${grid_name}/biog/BIOG_TOT_${grid_name}.nc

##> lightning NOx
 if ( $?CTM_LTNG_NO ) then   # $CTM_LTNG_NO is defined
    if ( $CTM_LTNG_NO == 'Y' || $CTM_LTNG_NO == 'T' ) then
       set ltngon = 1
    else
       set ltngon = 0
    endif
 else   # $CTM_LTNG_NO is not defined => $CTM_LTNG_NO == 'N
    set ltngon = 0
 endif

#> set output file name extensions
 setenv CTM_APPL ${GRID_NAME}_${APPL}_${CFG}_${SDATE}

#> set output file names
 set CONCfile  = CONC.${CTM_APPL}               # CTM_CONC_1
 set ACONCfile = ACONC.${CTM_APPL}              # CTM_ACONC_1
 set CGRIDfile = CGRID.${CTM_APPL}              # CTM_CGRID_1
 set DD1file   = DRYDEP.${CTM_APPL}             # CTM_DRY_DEP_1
 set DV1file   = DEPV.${CTM_APPL}               # CTM_DEPV_DIAG
 set PT1file   = PT3D.${CTM_APPL}               # CTM_PT3D_DIAG
 set BIO1file  = B3GTS_S.${CTM_APPL}            # B3GTS_S
 set SOIL1file = SOILOUT.${CTM_APPL}            # SOILOUT
 set WD1file   = WETDEP1.${CTM_APPL}            # CTM_WET_DEP_1
 set WD2file   = WETDEP2.${CTM_APPL}            # CTM_WET_DEP_2
 set AV1file   = AEROVIS.${CTM_APPL}            # CTM_VIS_1
 set AD1file   = AERODIAM.${CTM_APPL}           # CTM_DIAM_1
 set RJ1file   = PHOTDIAG1.${CTM_APPL}          # CTM_RJ_1
 set RJ2file   = PHOTDIAG2.${CTM_APPL}          # CTM_RJ_2
 set SSEfile   = SSEMIS.$CTM_APPL               # CTM_SSEMIS_1
 set DSEfile   = DUSTEMIS.$CTM_APPL             # CTM_DUST_EMIS_1
 set PA1file   = PA_1.${CTM_APPL}               # CTM_IPR_1
 set PA2file   = PA_2.${CTM_APPL}               # CTM_IPR_2
 set PA3file   = PA_3.${CTM_APPL}               # CTM_IPR_3
 set IRR1file  = IRR_1.${CTM_APPL}              # CTM_IRR_1
 set IRR2file  = IRR_2.${CTM_APPL}              # CTM_IRR_2
 set IRR3file  = IRR_3.${CTM_APPL}              # CTM_IRR_3
 set DEPVFSTfile = DEPVFST.${CTM_APPL}          # CTM_DEPV_FST
 set DEPVMOSfile = DEPVMOS.${CTM_APPL}          # CTM_DEPV_MOS
 set DDFSTfile = DDFST.${CTM_APPL}              # CTM_DRY_DEP_FST
 set DDMOSfile = DDMOS.${CTM_APPL}              # CTM_DRY_DEP_MOS

#> set floor file (neg concs)
 set LOG_DIR = $cwd
 setenv FLOOR_FILE ${LOG_DIR}/FLOOR_${APPL}
#setenv FLOOR_FILE $BASE/FLOOR_${CTM_APPL}

#> input files and directories

 source outck.q
 
 if ( $biogon ) then
    if ( $B3GTS_DIAG == 'Y' || $B3GTS_DIAG == 'T' ) then
       setenv B3GTS_S $OUTDIR/$EXEC"_B3GTS_S".${CTM_APPL}
    endif
    setenv SOILOUT $OUTDIR/$EXEC"_SOILOUT".${CTM_APPL}  # Biogenic NO soil output file
 endif

 setenv EMISDATE ${YEAR}${MONTH}${DAY}
    if ( $pt3don ) then
       setenv NPTGRPS 5
       set IN_PTpath  = ${M3DATA}/emis
       set CASE1 = 12US1_C25_2006am
       set CASE2 = 12US1_cmaq_cb05_tx_C25_2006am
       setenv CASE ${EMISDATE}_$CASE2
       set EMISpath = $IN_PTpath
       set EMISfile  = emis_mole_all_${CASE}.ncf
       setenv STK_GRPS_01 $IN_PTpath/stack_groups_ptnonipm_${CASE1}.ncf
       setenv STK_GRPS_02 $IN_PTpath/stack_groups_ptipm_${CASE1}.ncf
       setenv STK_GRPS_03 $IN_PTpath/stack_groups_othpt_${CASE1}.ncf
       setenv STK_GRPS_04 $IN_PTpath/stack_groups_seca_c3_${CASE1}.ncf
       setenv STK_GRPS_05 $IN_PTpath/stack_groups_ptfire_${EMISDATE}_${CASE1}.ncf
#      setenv PT3DDIAG Y  # optional 3d point source emissions diagnostic file [N]
#      setenv PT3DFRAC Y  # optional layer fractions diagnostic (play) file(s) [N]
       setenv LAYP_STTIME $STTIME
       setenv LAYP_NSTEPS $NSTEPS
       setenv STK_EMIS_01 $IN_PTpath/inln_mole_ptnonipm_${CASE}.ncf
       setenv STK_EMIS_02 $IN_PTpath/inln_mole_ptipm_${CASE}.ncf
       setenv STK_EMIS_03 $IN_PTpath/inln_mole_othpt_${CASE}.ncf
       setenv STK_EMIS_04 $IN_PTpath/inln_mole_seca_c3_${CASE}.ncf
       setenv STK_EMIS_05 $IN_PTpath/inln_mole_ptfire_${CASE}.ncf
       setenv LAYP_STDATE $STDATE
    else
#      set EMISpath = /data/bieser/smoke_res/v1.1/${GRID_NAME}
#      set EMISfile = EURODELTA/EMIS_EURODELTA_${GRID_NAME}_${STDATE}
       set EMISpath = ${EMIS_PATH}
       set EMISfile = ${EMIS_FILE}${SDATE}
    endif
    setenv EMIS_1 $EMISpath/{$EMISfile}


# START NEUMANND
#> Sea Salt emissions
# setenv SS_FILE SSEMIS.${GRID_NAME}_${CFG}_${MET_TYPE}_${AGRICULT_EMIS}_${OCEAN_EMIS}_${PROFILE_TYPE}_${STDATE} # MODIFIED
# setenv SS_FILE SSEMIS.BOX06_cb05tucl_ae5_aq_std_cdl_EMEP.2008150.col_S__${STDATE}
# setenv SS_FILE SSEMIS.${GRID_NAME}_${CFG}_cdl_EMEP.2008150.col_S__${STDATE}
# setenv SS_FILE SSEMIS.test.F.${ADDON}.${STDATE}
  setenv SS_FILE ssemis_${GRID_NAME}_ae5_OCnSZnSL_ov13_mode4_${STDATE}
# setenv SS_DIR $MYDATA/cctm/${GRID_NAME}/2008/ae5_ss/11_ANNAs_SCENARIOS_realWeather
# setenv SS_DIR $MYDATA/emis/${GRID_NAME}/ssemis
# setenv SS_DIR /storage/neumannd/data/emis/${GRID_NAME}
  setenv SS_DIR /storage/neumannd/data/ssemis/outfiles/${GRID_NAME}/${YEAR}
#> file containing the sea-salt emissions [ N|F ]
  setenv SSEMIS_1 ${SS_DIR}/${SS_FILE}
# END NEUMANND


#set TR_EMpath = 
#set TR_EMfile = 
 
 if ( $ltngon ) then
#> file (offline)
   set IN_LTpath  = ${M3DATA}/lightning
   setenv LTNGNO $IN_LTpath/nox_CMAQ-BENCHMARK.35L.$EMISDATE
#> inline
#    setenv LTNGNO "InLine" 
#> use lightning parameter file? [ Y|T ]
#    setenv LTNGPARAM Y
#> point to lightning parameter file (ignored if LTNGPARAM is [ N|F]
#    setenv LTNGPARM_FILE $IN_LTpath/params/LTNG_RATIO.2004.$MONTH.ioapi
#> diagnostic file?  [ N|F ]
#    setenv LTNGDIAG Y
#    setenv LTNGOUT $OUTDIR/${EXEC}.LTNGDIAG.${CTM_APPL}
#   unsetenv LTNGPARAM
#   if (! -e $LTNGNO) aget -a $IN_LTpath /asm2/MOD3EVAL/LNOx/emisLNOx/2004af/36US1/pnox3d.t$EMISDATE
 endif

 set ICdate = ${SDATE}
 @ ICdate = ${ICdate} - 1
 set ICyear = ${ICdate}
 @ ICyear = ${ICyear} / 1000
 set ICday = ${ICdate}
 @ ICday = ${ICday} - 1000 * ${ICyear}

 if (${ICday} == 0 ) then
   @ ICyear = ${ICyear} - 1
   if (${ICyear} % 4 == 0 ) then
     @ ICdate = 1000 * ${ICyear} + 366
   else
     @ ICdate = 1000 * ${ICyear} + 365
   endif
 endif

#set ICpath = $OUTDIR
#set ICfile = CCTM_e3aCGRID.d1b
#set ICpath = $M3DATA/icon
#set ICpath = ${OUTDIR}/
#set ICFILE = $EXEC.CONC.${CFG}_${ICdate}


 if ( ${RESTART} == "Y" ) then
   set ICpath  = ${OUTDIR} 
   set ICFILE  = CONC.${GRID_NAME}_${APPL}_${CFG}_${ICdate}
 else if ( ${RESTART} == "N" ) then
   set RESTART = Y
   if ( ${NEST} == "N" || ${IC_PROFILE} == "Y" ) then
#    set ICpath = $M3DATA/icon
     set ICpath = /storage/M3HOME/data/icon
     set ICFILE = ICON_${GRID_NAME}_profile_${MECH}
   else if ( ${NEST} == "Y" ) then
     set ICpath = ${M3DATA}/icon/m3conc
     set ICFILE = ICON_${APPL}_${GRID_NAME}_${CFG}_${ICdate}
   endif
 endif

# set ICFILE = ICON_${APPL}_${CFG}_profile
 setenv INIT_GASC_1 $ICpath/$ICFILE
 setenv INIT_AERO_1 $INIT_GASC_1
 setenv INIT_NONR_1 $INIT_GASC_1
 setenv INIT_TRAC_1 $INIT_GASC_1
 
#set BCpath = /data/M3HOME/data/bcon/CD72/2000_ECA
#set BCFILE = BCON_deg4nest_CD24_sa_2000_ECA_${SDATE}

 if ( ${USER_BC} == "Y" ) then
   set BCpath = ${BC_PATH_USER}
   set BCFILE = ${BC_FILE_USER}${STDATE}
 else if ( ${USER_BC} == "N" ) then
   if ( ${NEST} == "N" ) then
     set BCpath = ${M3DATA}/bcon/profile
     set BCFILE = BCON_${GRID_NAME}_profile_${MECH}
   else if ( ${NEST} == "Y" ) then
     set BCpath = ${M3DATA}/bcon/${GRID_NAME}/${MECH}
     set BCFILE = BCON_${APPL}_${GRID_NAME}_${CFG}_${STDATE}
   endif
 endif

 setenv BNDY_GASC_1 $BCpath/$BCFILE
 setenv BNDY_AERO_1 $BNDY_GASC_1
 setenv BNDY_NONR_1 $BNDY_GASC_1
 setenv BNDY_TRAC_1 $BNDY_GASC_1

#set EXTN = cd24_${SDATE}
#set METpath = /data/M3HOME/data/lmmcip/${GRID_NAME}/${YEAR}
#set METpath = /storage/M3HOME/data/lmmcip/CD72/${YEAR}/
 set METpath = /storage/M3HOME/data/lmmcip/${GRID_NAME}/${YEAR}
#set METpath = /storage/M3HOME/data/lmmcip/CD72/${YEAR}/
#set METpath   = /scratch/matthias/lmmcip3/EURODELTA/${YEAR}
 set EXTN      = ${grid_name}

 setenv GRID_DOT_2D $METpath/GRIDDOT2D_${EXTN}_${STDATE}
 setenv GRID_CRO_2D $METpath/GRIDCRO2D_${EXTN}_${STDATE}
 setenv MET_CRO_2D $METpath/METCRO2D_${EXTN}_${STDATE}
 setenv MET_CRO_3D $METpath/METCRO3D_${EXTN}_${STDATE}
 setenv MET_DOT_3D $METpath/METDOT3D_${EXTN}_${STDATE}
 setenv MET_BDY_3D $METpath/METBDY3D_${EXTN}_${STDATE}

 echo "ADDVAR64"
 setenv PROMPTFLAG N
 setenv IN_FILE ${MET_CRO_2D}
 setenv ADD_FILE /storage/bieser/SLTYP_CD72
 setenv VAR SLTYP
 setenv OUT_FILE /storage/bieser/tmp/METCRO2D_b_1
 rm ${OUT_FILE}
# /data/M3HOME/CMAQ/bin/addvar64

 setenv INPUT_FILE /storage/bieser/tmp/METCRO2D_b_1
 setenv OUTPUT_FILE /storage/bieser/tmp/METCRO2D_b_2
 rm ${OUTPUT_FILE}
 setenv OLD_VAR TEMPG
 setenv NEW_VAR SOIT1
# /data/M3HOME/CMAQ/bin/varchanger64

 setenv IN_FILE /storage/bieser/tmp/METCRO2D_b_2
 setenv ADD_FILE ${MET_CRO_2D}
 setenv VAR TEMPG
 setenv OUT_FILE /storage/bieser/tmp/METCRO2D_b_3
 rm ${OUT_FILE}
# /data/M3HOME/CMAQ/bin/addvar64
# setenv MET_CRO_2D ${OUT_FILE}

 
 set TR_DVpath = $METpath
 set TR_DVfile = $MET_CRO_2D

 set JVALpath  = $M3DATA/jproc/${MECH}
 set JVALfile  = JTABLE_${MECH}_${STDATE}
 setenv XJ_DATA $JVALpath/$JVALfile
 
#> ozone columne data for the photolysis model
 set OMIpath  = $M3DATA/raw/phot
 setenv OMI $OMIpath/OMI.dat

#> for the run control ...

 setenv CTM_STDATE      $STDATE
 setenv CTM_STTIME      $STTIME
 setenv CTM_RUNLEN      $NSTEPS
 setenv CTM_TSTEP       $TSTEP
 setenv CTM_PROGNAME    $EXEC

#> look for existing log files
                              
#set test = `ls CTM_LOG_???.${CTM_APPL}`
 set test = `ls CTM_LOG_???.*`
 if ( "$test" != "" ) then
    if ( $DISP == 'delete' ) then
       echo " ancillary log files being deleted"
       foreach file ( $test )
          echo " deleting $file"
          rm $file
          end
       else
       echo "*** Logs exist - run ABORTED ***"
       exit 1
       endif
    endif

#> - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

 #env

 ls -l $BASE/$EXEC; size $BASE/$EXEC
 unlimit
 limit

 if ( ${SERIAL_RUN} == "Y" ) then
   #> Executable call for single PE, uncomment to invoke
   setenv NPCOL_NPROW "1 1"; set NPROCS   = 1 # single processor setting
   echo " *** starting serial run with "$NPROCS" node ***"
   time  $BASE/$EXEC
 else if ( ${SERIAL_RUN} == "N" ) then
   #> Executable call for multiple PE, set location of MPIRUN script
   ### set MPI = /share/linux86_64/mvapich2/mvapich2-1.4/install_x86_64_intel111059/bin
   set MPI = /opt/openmpi/pgi/ib/bin
   set MPIRUN = $MPI/mpiexec
   echo " *** starting parallel run with "$NPROCS" nodes ***"
   time $MPIRUN --mca oob_tcp_listen_mode listen_thread -n $NPROCS $BASE/$EXEC
#  time $MPIRUN -n $NPROCS $BASE/$EXEC
 endif

 @ STDATE = ${STDATE} + 1
 date
 end

 echo "  -- End of CCTM script --"
 date

 exit
