MODULE module_coarse_average

IMPLICIT NONE

CONTAINS

  SUBROUTINE make_chem_coarser(chem,coarser_ratio,num_chem,its,ite,  &
                          jts,jte, kts,kte,ims,ime,jms,jme,kms,kme)

    ! Make aerosol fields as coarse as specified by coarser_ratio

    INTEGER, INTENT(IN)    :: coarser_ratio,num_chem,its,ite,jts,jte,    &
                              kts,kte,ims,ime,jms,jme,kms,kme
    REAL, DIMENSION( ims:ime, kms:kme, jms:jme, num_chem ),                 &
          INTENT(INOUT)    :: chem
    REAL, DIMENSION( ims:ime, kms:kme, jms:jme, num_chem )  :: chem_orig
    REAL :: value
    INTEGER :: i, j, k, n, chem_j, chem_i
    INTEGER :: n_squares, coarser_ix,coarser_jx,j_coarse,i_coarse,          &
         i_fine_start,j_fine_start,i_fine_end,j_fine_end
    
        
    print *, ' Making aerosol resolution coarser by ratio ',coarser_ratio
 
    chem_orig = chem

    chem_i = ite-its+1
    chem_j = jte-jts+1
    coarser_ix = chem_i/coarser_ratio
    coarser_jx = chem_j/coarser_ratio
    
    DO j_coarse = 1, coarser_jx
       DO i_coarse = 1, coarser_ix
          i_fine_start = (i_coarse-1)*coarser_ratio + its
          j_fine_start = (j_coarse-1)*coarser_ratio + jts
    
          i_fine_end = i_fine_start + coarser_ratio - 1
          j_fine_end = j_fine_start + coarser_ratio - 1

          DO k = kts, kte
             DO n=3,3
                value = 0.
                n_squares = 0
                ! Find average value in coarser_ratio*coarser_ratio area
                DO j = j_fine_start, j_fine_end
                   DO i = i_fine_start, i_fine_end
                      value = value + chem_orig(i,k,j,n)
                      n_squares = n_squares + 1
                   END DO
                END DO

                IF(n_squares .EQ. 0) THEN
                   WRITE(*,*) 'WARNING: Zero-division during interpolation!'
                END IF

                ! Calculate average:
                value = value/n_squares

                IF(value .LT. 0) THEN
                   WRITE(*,*) 'WARNING: Results in Negative Average!'
                END IF

                ! Replace old value by average value
                DO j = j_fine_start, j_fine_end
                   DO i = i_fine_start, i_fine_end
                      chem(i,k,j,n) = value
                   END DO
                END DO
             END DO
          END DO
       END DO
    END DO

  END SUBROUTINE make_chem_coarser

  SUBROUTINE make_met_coarser(t_phy,p_phy,moist,alt,coarser_ratio,  &
                              t_phy_avg,p_phy_avg,moist_avg,num_moist, &
                              alt_avg,its,ite,jts,jte,kts,kte,ims,    & 
                              ime,jms,jme,kms,kme)

    ! Make aerosol fields as coarse as specified by coarser_ratio

    INTEGER, INTENT(IN)    :: coarser_ratio,num_moist,its,ite,jts,jte,    &
                              kts,kte,ims,ime,jms,jme,kms,kme
    REAL, DIMENSION( ims:ime, kms:kme, jms:jme ),                 &
          INTENT(IN)    :: t_phy, p_phy, alt
    REAL, DIMENSION( ims:ime, kms:kme, jms:jme, num_moist),     &
          INTENT(IN)    :: moist
    REAL, DIMENSION( ims:ime, kms:kme, jms:jme ),                 &
          INTENT(OUT)    :: t_phy_avg, p_phy_avg, alt_avg
    REAL, DIMENSION( ims:ime, kms:kme, jms:jme, num_moist),      &
          INTENT(OUT)    :: moist_avg
    REAL :: value_t, value_p, value_m, value_a
    INTEGER :: i, j, k, chem_j, chem_i, nm
    INTEGER :: n_squares, coarser_ix,coarser_jx,j_coarse,i_coarse,          &
         i_fine_start,j_fine_start,i_fine_end,j_fine_end


!    print *, ' Making aerosol resolution coarser by ratio ',coarser_ratio

    t_phy_avg = 0.0
    p_phy_avg = 0.0
    moist_avg = 0.0
    alt_avg = 0.0

    chem_i = ite-its+1
    chem_j = jte-jts+1
    coarser_ix = chem_i/coarser_ratio
    coarser_jx = chem_j/coarser_ratio

    DO j_coarse = 1, coarser_jx
       DO i_coarse = 1, coarser_ix
          i_fine_start = (i_coarse-1)*coarser_ratio + its
          j_fine_start = (j_coarse-1)*coarser_ratio + jts

          i_fine_end = i_fine_start + coarser_ratio - 1
          j_fine_end = j_fine_start + coarser_ratio - 1

          DO k = kts, kte
             DO nm = 1, num_moist
             value_t = 0.
             value_p = 0.
             value_m = 0.
             value_a = 0.
             n_squares = 0
             ! Find average value in coarser_ratio*coarser_ratio area
                DO j = j_fine_start, j_fine_end
                   DO i = i_fine_start, i_fine_end
                      value_t = value_t + t_phy(i,k,j)
                      value_p = value_p + p_phy(i,k,j)
                      value_m = value_m + moist(i,k,j,nm)
                      value_a = value_a + alt(i,k,j)
                      n_squares = n_squares + 1
                   END DO
                END DO

                IF(n_squares .EQ. 0) THEN
                   WRITE(*,*) 'WARNING: Zero-division during interpolation!'
                END IF!

             ! Calculate average:!
                value_t = value_t/n_squares
                value_p = value_p/n_squares
                value_m = value_m/n_squares
                value_a = value_a/n_squares!

             ! Replace old value by average value
                DO j = j_fine_start, j_fine_end
                   DO i = i_fine_start, i_fine_end
                      t_phy_avg(i,k,j) = value_t
                      p_phy_avg(i,k,j) = value_p
                      moist_avg(i,k,j,nm) = value_m
                      alt_avg(i,k,j) = value_a
                   END DO
                END DO
             END DO
          END DO
       END DO
    END DO
  END SUBROUTINE make_met_coarser

  SUBROUTINE make_3dvar_coarser(avevar,coarser_ratio,its,ite,  &
                          jts,jte, kts,kte,ims,ime,jms,jme,kms,kme)
  
    ! Make aerosol fields as coarse as specified by coarser_ratio

    INTEGER, INTENT(IN)    :: coarser_ratio,its,ite,jts,jte,    &
                              kts,kte,ims,ime,jms,jme,kms,kme
    REAL, DIMENSION( ims:ime, kms:kme, jms:jme ),                 &
          INTENT(INOUT)    :: avevar
    REAL, DIMENSION( ims:ime, kms:kme, jms:jme )  :: avevar_orig
    REAL :: value
    INTEGER :: i, j, k, n, ave_j, ave_i
    INTEGER :: n_squares, coarser_ix,coarser_jx,j_coarse,i_coarse,          &
         i_fine_start,j_fine_start,i_fine_end,j_fine_end

    print *, ' Making 3d variable coarser by ratio ',coarser_ratio

    avevar_orig = avevar

    ave_i = ite-its+1
    ave_j = jte-jts+1
    coarser_ix = ave_i/coarser_ratio
    coarser_jx = ave_j/coarser_ratio

    DO j_coarse = 1, coarser_jx
       DO i_coarse = 1, coarser_ix
          i_fine_start = (i_coarse-1)*coarser_ratio + its
          j_fine_start = (j_coarse-1)*coarser_ratio + jts

          i_fine_end = i_fine_start + coarser_ratio - 1
          j_fine_end = j_fine_start + coarser_ratio - 1

          DO k = kts, kte
             value = 0.
             n_squares = 0

             ! Find average value in coarser_ratio*coarser_ratio area
             DO j = j_fine_start, j_fine_end
                DO i = i_fine_start, i_fine_end
                   value = value + avevar_orig(i,k,j)
                   n_squares = n_squares + 1
                END DO 
             END DO  

             IF(n_squares .EQ. 0) THEN
                WRITE(*,*) 'WARNING: Zero-division during interpolation!'
             END IF

             ! Calculate average:
             value = value/n_squares

             IF(value .LT. 0) THEN
                WRITE(*,*) 'WARNING: Results in Negative Average!'
             END IF 

             ! Replace old value by average value
             DO j = j_fine_start, j_fine_end
                DO i = i_fine_start, i_fine_end
                   avevar(i,k,j) = value
                END DO
             END DO
          END DO
       END DO
    END DO
 
  END SUBROUTINE make_3dvar_coarser

END MODULE module_coarse_average
