function [oxygens2D, CStarBasis, OScBasis] = ONum2D

% cNum2D
%    Return basic properties in the 2D basis set, esp avg carbn number
%    This is mostly for reference, but also important to OM calc.
%    The basic relations here are
%   d log10 C* / dO = -1.7 (assumed average, rougly for acids)
%   H:C = 2 - O:C
%   OSc = 2O:C - H:C = 3 O:C - 2
%   O:C = (1/3) (OSc + 2);

CStarBasis = [1e-5 1e-4 1e-3 1e-2 1e-1 1e0 1e1 1e2 1e3 1e4 1e5 1e6 1e7 1e8 1e9];

O2CBasis = [1; .9; .8; .7; .6; .5; .4; .3; .2; .1; 0];
OScBasis = [+1.0; +0.7; +0.4; +0.1; -0.2; -0.5; -0.8; -1.1; -1.4; -1.7; -2.0];

% This is an average carbon number in the 2D basis set 
%    -5   -4   -3   -2   -1   00   01   02   03   04   05   06   07   08   09
oxygens2D = [ ...
8.0 7.5 7.0 6.6 6.1 5.7 5.2 4.8 4.3 3.9 3.4 3.0 2.5 2.0 1.6; ...
7.8 7.3 6.9 6.4 6.0 5.5 5.1 4.7 4.2 3.8 3.3 2.9 2.4 2.0 1.6; ...
7.5 7.1 6.7 6.2 5.8 5.4 4.9 4.5 4.1 3.7 3.2 2.8 2.4 1.9 1.5; ...
7.2 6.8 6.4 6.0 5.6 5.2 4.8 4.3 3.9 3.5 3.1 2.7 2.3 1.9 1.4; ...
6.9 6.5 6.1 5.7 5.3 4.9 4.5 4.1 3.8 3.4 3.0 2.6 2.2 1.8 1.4; ...
6.5 6.1 5.7 5.4 5.0 4.6 4.3 3.9 3.5 3.1 2.8 2.4 2.0 1.7 1.3; ...
5.9 5.6 5.3 4.9 4.6 4.2 3.9 3.6 3.2 2.9 2.5 2.2 1.9 1.5 1.2; ...
5.2 4.9 4.6 4.3 4.0 3.7 3.4 3.1 2.8 2.5 2.2 1.9 1.6 1.3 1.0; ...
4.2 3.9 3.7 3.5 3.2 3.0 2.7 2.5 2.3 2.0 1.8 1.5 1.3 1.1 0.8; ...
2.6 2.5 2.3 2.2 2.0 1.9 1.7 1.6 1.4 1.3 1.1 1.0 0.8 0.7 0.5; ...
0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0; ...
];

