function [hydrogens2D, CStarBasis, OScBasis] = HNum2D

% cNum2D
%    Return basic properties in the 2D basis set, esp avg carbn number
%    This is mostly for reference, but also important to OM calc.
%    The basic relations here are
%   d log10 C* / dO = -1.7 (assumed average, rougly for acids)
%   H:C = 2 - O:C
%   OSc = 2O:C - H:C = 3 O:C - 2
%   O:C = (1/3) (OSc + 2);

CStarBasis = [1e-5 1e-4 1e-3 1e-2 1e-1 1e0 1e1 1e2 1e3 1e4 1e5 1e6 1e7 1e8 1e9];

O2CBasis = [1; .9; .8; .7; .6; .5; .4; .3; .2; .1; 0];
OScBasis = [+1.0; +0.7; +0.4; +0.1; -0.2; -0.5; -0.8; -1.1; -1.4; -1.7; -2.0];

% This is an average carbon number in the 2D basis set 
%    -5   -4   -3   -2   -1   00   01   02   03   04   05   06   07   08   09
hydrogens2D = [ ...
08.0 07.5 07.0 06.6 06.1 05.7 05.2 04.8 04.3 03.9 03.4 03.0 02.5 02.0 01.6; ...
09.5 08.9 08.4 07.9 07.3 06.8 06.2 05.7 05.1 04.6 04.1 03.5 03.0 02.4 01.9; ...
11.3 10.6 10.0 09.4 08.7 08.1 07.4 06.8 06.1 05.5 04.8 04.2 03.5 02.9 02.3; ...
13.5 12.7 11.9 11.2 10.4 09.6 08.8 08.1 07.3 06.5 05.8 05.0 04.2 03.5 02.7; ...
16.1 15.2 14.3 13.4 12.4 11.5 10.6 09.7 08.8 07.8 06.9 06.0 05.1 04.1 03.2; ...
19.4 18.3 17.2 16.1 15.0 13.9 12.8 11.7 10.6 09.4 08.3 07.2 06.1 05.0 03.9; ...
23.7 22.4 21.0 19.7 18.3 16.9 15.6 14.2 12.9 11.5 10.2 08.8 07.5 06.1 04.7; ...
29.5 27.8 26.1 24.4 22.7 21.0 19.4 17.7 16.0 14.3 12.6 10.9 09.3 07.6 05.9; ...
37.5 35.4 33.2 31.1 28.9 26.8 24.6 22.5 20.4 18.2 16.1 13.9 11.8 09.6 07.5; ...
49.6 46.8 44.0 41.1 38.3 35.4 32.6 29.8 26.9 24.1 21.3 18.4 15.6 12.8 09.9; ...
70.0 66.0 62.0 58.0 54.0 50.0 46.0 42.0 38.0 34.0 30.0 26.0 22.0 18.0 14.0; ...
];

