function [carbons2D, CStarBasis, OScBasis] = CNum2D

% cNum2D
%    Return basic properties in the 2D basis set, esp avg carbn number
%    This is mostly for reference, but also important to OM calc.
%    The basic relations here are
%   d log10 C* / dO = -1.7 (assumed average, rougly for acids)
%   H:C = 2 - O:C
%   OSc = 2O:C - H:C = 3 O:C - 2
%   O:C = (1/3) (OSc + 2);

CStarBasis = [1e-5 1e-4 1e-3 1e-2 1e-1 1e0 1e1 1e2 1e3 1e4 1e5 1e6 1e7 1e8 1e9];

O2CBasis = [1; .9; .8; .7; .6; .5; .4; .3; .2; .1; 0];
OScBasis = [+1.0; +0.7; +0.4; +0.1; -0.2; -0.5; -0.8; -1.1; -1.4; -1.7; -2.0];

% This is an average carbon number in the 2D basis set 
%    -5   -4   -3   -2   -1   00   01   02   03   04   05   06   07   08   09
carbons2D = [ ...
08.0 07.5 07.0 06.6 06.1 05.7 05.2 04.8 04.3 03.9 03.4 03.0 02.5 02.0 01.6 ; ... % +1.0
08.6 08.1 07.6 07.1 06.7 06.2 05.7 05.2 04.7 04.2 03.7 03.2 02.7 02.2 01.7 ; ... % +0.7
09.4 08.9 08.3 07.8 07.3 06.7 06.2 05.6 05.1 04.6 04.0 03.5 03.0 02.4 01.9 ; ... % +0.4
10.4 09.8 09.2 08.6 08.0 07.4 06.8 06.2 05.6 05.0 04.4 03.8 03.3 02.7 02.1 ; ... % +0.1
11.5 10.9 10.2 09.5 08.9 08.2 07.6 06.9 06.3 05.6 04.9 04.3 03.6 03.0 02.3 ; ... % -0.2
13.0 12.2 11.5 10.7 10.0 09.3 08.5 07.8 07.0 06.3 05.6 04.8 04.1 03.3 02.6 ; ... % -0.5
14.8 14.0 13.1 12.3 11.4 10.6 09.7 08.9 08.1 07.2 06.4 05.5 04.7 03.8 03.0 ; ... % -0.8
17.3 16.3 15.3 14.4 13.4 12.4 11.4 10.4 09.4 08.4 07.4 06.4 05.4 04.5 03.5 ; ... % -1.1
20.8 19.6 18.5 17.3 16.1 14.9 13.7 12.5 11.3 10.1 08.9 07.7 06.5 05.4 04.2 ; ... % -1.4
26.1 24.6 23.1 21.6 20.1 18.7 17.2 15.7 14.2 12.7 11.2 09.7 08.2 06.7 05.2 ; ... % -1.7
35.0 33.0 31.0 29.0 27.0 25.0 23.0 21.0 19.0 17.0 15.0 13.0 11.0 09.0 07.0 ; ... % -2.0
];


