function f = poly4dx0(X,a,n,p)
% POLY4Off Fourth order polynomial with offset
% poly4Off(X,a) returns y = a(2) + a(3) * (X-a(1)) + ...
% poly4Off(X,a,n) returns the derivative of poly4Off at X

if size(a,1) == 1, a = a'; end;
if nargin < 3, n = 0; end
if nargin < 4, p = 0; end


if (p~=2) 
    Xa = X - a(1);
end

% The x derivatives of the function
switch n
    case 1, f =  2*a(3)*Xa + 3*a(4)*Xa.^2 + 4*a(5)*Xa.^3;, return;
end

% The a derivatives of the function
switch p
    case 1, f = - 2*a(3)*Xa - 3*a(4)*Xa.^2 - 4*a(5)*Xa.^3;, return;
    case 2, f = ones(size(X));, return;
    case 3, f = Xa.^2;, return;
    case 4, f = Xa.^3;, return;
    case 5, f = Xa.^4;, return;
end

% The function
f = a(2) + a(3)*Xa.^2 + a(4)*Xa.^3 + a(5)*Xa.^4;
