;+
;
 PRO ln_parameterisation_bcfa, rm, S, FILE=file, $
                               Cext, Csca, asymmetry, SSA, x
;
;
;
;
;
;
;-

  
     ; Get the parameters.
     x = READ_PARAMETERISATION_BCFA( file )

     ; Basic variables.
     wl = x.wl
     Df = x.Df
     a  = x.spherule_radius

     nwl = N_ELEMENTS( wl )
     nDf = N_ELEMENTS( Df )

     ; The spread of the log-normal distribution
     sigma = ALOG( S )
     factor = ( DOUBLE( rm / a ) )^3

     ; Output arrays
     Cext = FLTARR(      nDf, nwl )
     Csca = FLTARR(      nDf, nwl )
     asymmetry = FLTARR( nDf, nwl )


     ; The degree of fit for the polynomial is the number of 
     ; elements in the extinction parameterisation less one.
     ndeg = N_ELEMENTS( x.param_ext[*,0,0] ) - 1

     FOR iwl=0, nwl-1 DO BEGIN
        FOR iDf=0, nDf-1 DO BEGIN

           k = REFORM( x.param_ext[ *,iDf,iwl] )
           w = REFORM( x.param_ssa[ *,iDf,iwl] )
           g = REFORM( x.param_asym[*,iDf,iwl] )

           ext_sum = k[0]
           FOR ideg=1,ndeg DO ext_sum += $
              k[ideg] * factor^(ideg) * EXP( 0.5*(3*ideg*sigma)^2 )




           sca_sum = ( w[0] - 3*w[2]*ALOG(a) ) * ext_sum
           FOR ideg=0,ndeg DO sca_sum += $
              k[ideg]*( w[1]*factor^(ideg+1) * EXP(0.5*(3*(ideg+1)*sigma)^2) + $
                        3*w[2]*factor^(ideg)*EXP(0.5*(3*ideg*sigma)^2)*(ALOG(rm)+3*ideg*sigma^2) )





           g_sum  = ( g[0] - 3*g[2] * ALOG(a) ) * sca_sum


           FOR ideg=0,ndeg DO g_sum += $
              k[ideg]*factor^(ideg) * EXP(0.5*(3*ideg*sigma)^2) * $
                    ( factor*EXP(4.5*sigma^2*(2*ideg+1)) *  $
                      ( g[1]*(w[0]-3*w[2]*ALOG(a)) + $
                        3*(g[1]*w[2]+g[2]*w[1])*(ALOG(rm)+3*(ideg+1)*sigma^2) ) + $
                      factor^2*EXP(18*sigma^2*(ideg+1)) * g[1] * w[1] + $
                      3*g[2]*( (w[0]-3*w[2]*ALOG(a))*(ALOG(rm)+3*ideg*sigma^2) + $
                               3*w[2]*( (ALOG(rm)+3*ideg*sigma^2)^2 + sigma^2)  )    ) 

           
           ; Asymmetry is weighted by the scattering so need to divide by this afterwards.
           g_sum = g_sum / sca_sum
           

           Cext[     iDf, iwl ] = ext_sum
           Csca[     iDf, iwl ] = sca_sum
           asymmetry[iDf, iwl ] = g_sum

        ENDFOR 
     ENDFOR
     
     ssa  = Csca / Cext


     RETURN

 END 
