PROGRAM test_Eq1_Kappa
!
! *** automatically generated with test_Eq1_Kappa.j ***
!
! AUTHOR
! ------
! Swen Metzger <swen.metzger@mpic.de>
!
!      Department of Atmospheric Chemistry,
!      Max Planck Institute for Chemistry, Mainz, Germany.
!      Copyright 2012+. All rights reserved.
!
!      References
!      ---------
!      [1] CRC Hanbook of Chemistry and Physics, 85th Edition, 2004-2005.
!
!      [2] Seinfeld and Pandis, 1998.
!          Atmospheric chemistry and physics, J. Wiley and Sons, Inc., New York.
!
!      [3] Rose et al., 2008.
!          Calibration and measurement uncertainties of a continuous-flow 
!          cloud condensation nuclei counter (DMT-CCNC): activation of ammonium 
!          sulfate and sodium chloride aerosol particles in theory and experiment,
!          Atmos. Chem. Phys., 8, 1153–1179, www.atmos-chem-phys.net/8/1153/2008/
!
!      [4] S. Metzger, B. Steil, L. Xu, J. E. Penner, and J. Lelieveld: ACP, 2012;
!          New representation of water activity based on a single solute specific constant
!          to parameterize the hygroscopic growth of aerosols in atmospheric models.
!------------------------------------------------------------------------------------
IMPLICIT NONE
!
INTEGER,PARAMETER  :: dp = SELECTED_REAL_KIND(12,307)
!--------------------------------------------------------------------------------
INTEGER              :: i,j,k                       ! loop indices
INTEGER, PARAMETER   :: imax = 686                  ! maximum loop count (100 + 586 of Rose et. al)
INTEGER, PARAMETER   :: IUNIT = 1                   ! I/O Unit number - read
INTEGER, PARAMETER   :: OUNIT = 2                   ! I/O Unit number - write
!--------------------------------------------------------------------------------
REAL(dp),PARAMETER   :: Dd=1_dp*1.e-6_dp         ! dry diameter [m]
REAL(dp),PARAMETER   :: RHDrefT0=0.7528_dp     ! reference RHD [-]
REAL(dp),PARAMETER   :: RHDrefTc=25.00_dp     ! reference RHD T-coefficient [-]
REAL(dp),PARAMETER   :: kappa=1.28_dp           ! Kappa value [-], Eq. (30) of [3]
REAL(dp),PARAMETER   :: vi=1.737506_dp                 ! vi value [-], Table 2 of [4]
!--------------------------------------------------------------------------------
REAL(dp),PARAMETER   :: Phi=3.141592653589793_dp    ! Phi [-]
REAL(dp),PARAMETER   :: T0=298.15_dp                ! reference temperature, T0 [K]
REAL(dp),PARAMETER   :: R=8.314_dp                  ! universal gas constant [J/K/mol]
REAL(dp),PARAMETER   :: sigma=0.0761_dp             ! surface tension of H2O at 273 K [N/m]
REAL(dp),PARAMETER   :: T=298.15_dp                 ! default 298.15 temperature, T [K]
!--------------------------------------------------------------------------------
! compound specification; thermodynamic data of [1]
REAL(dp),PARAMETER   :: ns=1.000e-6_dp                 ! solute "concentration" [mol] - w.r.t. per m3(air)
REAL(dp),PARAMETER   :: Ds=2170.000_dp                 ! solute density [kg/m3]
REAL(dp),PARAMETER   :: Dw=997.1_dp                 ! water  density [kg/m3]
REAL(dp),PARAMETER   :: Ms=0.058440_dp                 ! molar mass solute [kg/mol]
REAL(dp),PARAMETER   :: Mw=0.018015_dp              ! molar mass H2O  [kg/mol]
REAL(dp),PARAMETER   :: Ws=0.264700_dp                 ! mass fraction solubility [-]; Ws=ms/(ms+mw); ms=mw/(1/Ws-1)
REAL(dp),PARAMETER   :: mwat=1._dp                  ! initial mass of H20 [1 kg]
REAL(dp),PARAMETER   :: msat=mwat/(1._dp/Ws-1._dp)  ! saturation mass [kg] that completely dissolves at equilbrium RHD
REAL(dp),PARAMETER   :: nsat=msat/Ms                ! number of moles of solute in a saturated solution at RHD
REAL(dp)             :: RHD,RHDref                  ! calculated and reference RHD at T and T0 [-]
REAL(dp)             :: sm,sm0                      ! solute molality, saturation molality at RHD[mol/kg(H2O)], Eq.(A11)
REAL(dp)             :: aw                          ! water activity [-]
REAL(dp)             :: A                           ! A term [-], Eq.(2) of [4]
REAL(dp)             :: B                           ! B term [-], Eq.(3) of [4]
REAL(dp)             :: WH2O                        ! calculated aerosol associated water mass [ug(H2O)/m3(air)]
REAL(dp)             :: GF                          ! diameter growth factor [0-1], Eq.(A2) of [4]
REAL(dp)             :: Ke                          ! Kelvin term [-], Eq. (A1) of [4]
REAL(dp)             :: Dpw                         ! wet diameter [m]
REAL(dp)             :: Sc_ref                      ! E-AIM   critical supersaturation [-]
REAL(dp)             :: Sc_cal                      ! Eq1 critical supersaturation [-]
REAL(dp),DIMENSION(imax):: RH                       ! calculated RH from Eq1
REAL(dp),DIMENSION(imax):: &                        ! E-AIM reference data:
                           AWref, &                 ! water activity  (input)
                           SMref, &                 ! solute molality (input)
                           WH2Oref,&                ! derived water mass
                           GFref, &                 ! derived growth factor
                           Dpwref,&                 ! derived wet diameter
                           Keref, &                 ! derived Kelvin-term
                           RHref                    ! derived RH
!------------------------------------------------------------------------------------
WRITE(*,'(A)') '(I) reading / calculating E-AIM reference data ...'
!------------------------------------------------------------------------------------
OPEN(unit=IUNIT,file= './input/NaCl_E-AIM_inp.txt',       status='old',form='formatted')
OPEN(unit=OUNIT,file='./output/NaCl_E-AIM_out_1um.txt',status='new',form='formatted')
! calculate T-dependency of RHDref
RHDref = MAX(0._dp,MIN(1._dp,RHDrefT0*EXP(RHDrefTc*(1._dp/T-1._dp/T0))))
! initialize
AWref  (:) = 0._dp
WH2Oref(:) = 0._dp
GFref  (:) = 1._dp
DO i=1,imax
   ! read water activity (aw) and solute molality (sm)
   READ(IUNIT,'(2E16.9)') AWref(i),SMref(i)
   ! calculate water mass from solute molality - Eq. (A11) of [4]
   IF(SMref(i) > 0._dp) &
   WH2Oref (i)   = ns / SMref(i)
   ! calculate mass equivalent (diameter) growth factor - Eq. (A2) of [4]
   IF(WH2Oref(i) > 0._dp) &
   GFref   (i)   = (Ds*WH2Oref(i)/(ns*Ms*Dw)+1)**(1._dp/3._dp)
   ! calculate Ke from GF using Eq. (A1) of [4]
   Keref   (i)   = exp(4._dp*Mw*sigma/(R*T*Dw*GFref(i)*Dd))
   ! calculate RH from Eq. (A1) of [4]
   RHref   (i)   = AWref(i)*Keref(i)
   ! set growth factor to unity if RH is below the compound's RHD
   IF(RHref(i)   < RHDref*Keref(i)) &
   GFref   (i)   = 1._dp
   ! calculate wet radius from growth factor - Eq. (A2) of [4]
   Dpwref  (i)   = GFref(i)*Dd
   WRITE(OUNIT,'(I6,10E18.9)') i,AWref (i), RHref(i)*100._dp,WH2Oref(i)*1.e9_dp, Keref(i),&
                                Dpwref(i)*1.e6_dp,(RHref(i)-1._dp)*100._dp,GFref(i),Dd*1.e6_dp,SMref(i),0._dp
END DO
CLOSE(IUNIT)
CLOSE(OUNIT)
WRITE(*,'(A)') 'finished ...'
!------------------------------------------------------------------------------------
IF     ("Eq1" == "Eq1") THEN
   WRITE(*,'(A)') '(II) solving Eq.(1)  of [4] as a function of wet diameter using Eq1 method ...'
ELSE IF("Eq1" == "Kappa") THEN
   WRITE(*,'(A)') '(II) solving Eq.(30) of [3] as a function of wet diameter using Eq1 method ...'
ELSE
   WRITE(*,'(A)') 'choose parameterization "Eq1" or "Kappa"'
   STOP
END IF
!------------------------------------------------------------------------------------
OPEN(unit=OUNIT,file='./output/NaCl_Eq1_out_1um.txt',status='new',form='formatted')
! initialize
! growth factor
GF = 1._dp
! Kelvin term
Ke = 1._dp
! A term
A  = 1._dp
! B term
B  = 0._dp
! aerosol water mass
WH2O = 0._dp
! wet diameter = dry diameter
Dpw  = Dd
! saturation molality at RHD
sm0= nsat
! (re-)calculate Ke from GF using Eq. (A1) of [4]
Ke = exp(4._dp*Mw*sigma/(R*T*Dw*GF*Dd))
!-----------------------------------------------------------------
IF     ("Eq1" == "Eq1") THEN
   ! calculate A-term - Eq. (2) of [4]
   A = exp(-Mw*vi*sm0**vi)*(1._dp+Mw*vi*sm0)
   ! calculate B-term - Eq. (3) of [4]
   B = 1._dp/(1._dp+1._dp/(Ms*vi*sm0))*(vi*sm0)**(-1._dp/vi)
   ! calculate RHD with vi method - Eq. (5b) of [4]
   RHD = Ke/(A+Mw*vi*(sm0+B)**vi)
ELSE IF("Eq1" == "Kappa") THEN
   ! calculate RHD with Kappa method - Eq. (30) of [3]
   RHD = Ke*(Dpw**3._dp-Dd**3._dp)/(Dpw**3._dp-Dd**3._dp*(1._dp-kappa))
END IF
WRITE(*,'(A,4F12.6)')' NaCl - RHDref,RHD,vi,kappa ',RHDref,RHD,vi,kappa
DO i = 1,imax
   ! assign wet diameter [m] (derived from E-AIM solute molality)
   Dpw = Dpwref(i)
   ! (re-)calculate mass equivalent (diameter) growth factor - Eq. (A2) of [4]
   GF = Dpw / Dd
   ! (re-)calculate Ke from GF using Eq. (A1) of [4]
   Ke = exp(4._dp*Mw*sigma/(R*T*Dw*GF*Dd))
   ! initialize solute molality from saturation molality (solubility) - Eq. (A11) of [4]
   sm  = sm0
   ! (re-)calculate solute molality from growth factor - Eq. (A2) of [4]
   IF(GF > 1._dp) &
   sm = 1._dp/((GF**3._dp-1._dp)*Ms*Dw/Ds)
   IF     ("Eq1" == "Eq1") THEN
      ! calculate A-term - Eq. (2) of [4]
      A = exp(-Mw*vi*sm**vi)*(1._dp+Mw*vi*sm)
      ! calculate B-term - Eq. (3) of [4]
      B = 1._dp/(1._dp+1._dp/(Ms*vi*sm))*(vi*sm)**(-1._dp/vi)
      ! calculate RH using vi method - Eq. (5a) of [4]
      RH(i) = Ke/(A+Mw*vi*(sm+B)**vi)
   ELSE IF("Eq1" == "Kappa") THEN
      ! calculate RH using kappa method - Eq. (30) of [3]
      RH(i) = Ke*(Dpw**3._dp-Dd**3._dp)/(Dpw**3._dp-Dd**3._dp*(1._dp-kappa))
   END IF
   ! calculate water activity from RH/Ke - Eq. (A1) of [4]
   aw = RH(i) / Ke
   ! calculate aerosol water mass [kg/m3(air)] - Eq. (A11) of [4]
   WH2O = ns / sm
   WRITE(OUNIT,'(I6,11E18.9)') i,aw,  RH(i)*100._dp,WH2O*1.e9_dp,Ke,&
                               Dpw*1.e6_dp,(RH(i)-1._dp)*100._dp,GF,Dd*1.e6_dp,sm,vi,kappa
END DO
CLOSE(OUNIT)
! pick critical supersaturation according to [2]
Sc_ref = 0._dp
DO i=1,imax
   IF(RHref(i) > Sc_ref) THEN
      Sc_ref   = RHref(i)
   END IF
END DO
Sc_ref = Sc_ref*100._dp-100._dp
Sc_cal = 0._dp
DO i=1,imax
   IF(RH(i) > Sc_cal) THEN
      Sc_cal   = RH(i)
   END IF
END DO
Sc_cal = Sc_cal*100._dp-100._dp
! open output file
OPEN(unit=OUNIT,file='./output/NaCl_Eq1_out_1um_Sc.txt',status='new',form='formatted')
WRITE(OUNIT,'(3E15.6)') Sc_ref,Sc_cal,Dd*1.e6_dp
CLOSE(OUNIT)
WRITE(*,'(A)') 'finished ...'
STOP
!_________________________________________________________________________________________________________________________________
END PROGRAM test_Eq1_Kappa
