DROP TABLE data;
DROP TABLE crop;
DROP TABLE publication;
DROP TABLE ecosys_modis;
DROP TABLE ecosys_yl;
DROP TABLE koeppen_main;
DROP TABLE units;

CREATE TABLE data (ID SERIAL,
       pub_ID         INTEGER,
       longitude      FLOAT,
       latitude       FLOAT,
       sdate          DATE,
       edate          DATE,
       cultiv         BOOLEAN,
       crop           INTEGER,
       modis_ID       INTEGER,
       yl_ID          INTEGER,
       kp_ID          INTEGER,
       NO_emis        FLOAT,
       NO_emis_SD     FLOAT,
       N2O_emis       FLOAT,
       sand           FLOAT,
       silt           FLOAT,
       clay           FLOAT,
       C_org          FLOAT,
       N_org          FLOAT,
       extr_NO3       FLOAT,
       extr_NH4       FLOAT,
       extr_anorg_N   FLOAT,
       pH             FLOAT,
       bd             FLOAT,
       N_rate         FLOAT,
       f_loss_rate    FLOAT,
       N_deposition   FLOAT);

CREATE TABLE units (field VARCHAR,
       units	   VARCHAR,
       description VARCHAR);

CREATE TABLE crop (id INTEGER,
       name VARCHAR);

CREATE TABLE publication (pub_ID SERIAL,
       bibtex                    VARCHAR,
       type                      VARCHAR,
       author                    VARCHAR,
       title                     VARCHAR,
       year                      INTEGER,
       journal                   VARCHAR,
       booktitle                 VARCHAR,
       volume                    VARCHAR,
       spage                     VARCHAR,
       epage                     VARCHAR);

CREATE TABLE ecosys_modis (modis_ID SERIAL,
       name                         VARCHAR);

CREATE TABLE ecosys_yl (yl_ID SERIAL,
       name                   VARCHAR);

CREATE TABLE koeppen_main (kp_ID SERIAL,
       letter                    CHAR,
       name                      VARCHAR); 

       
INSERT INTO crop VALUES (1,    'bare');
INSERT INTO crop VALUES (2,    'na');
INSERT INTO crop VALUES (11,   'cabbage');
INSERT INTO crop VALUES (12,   'carrot');
INSERT INTO crop VALUES (13,   'celery');
INSERT INTO crop VALUES (14,   'cowpea');
INSERT INTO crop VALUES (15,   'garlic');
INSERT INTO crop VALUES (16,   'komatsuna');
INSERT INTO crop VALUES (17,   'pac choi');
INSERT INTO crop VALUES (18,   'radish');
INSERT INTO crop VALUES (19,   'spinach');
INSERT INTO crop VALUES (20,   'vegetable');
INSERT INTO crop VALUES (100,  'cotton');
INSERT INTO crop VALUES (102,  'soybean');
INSERT INTO crop VALUES (103,  'sugar cane');
INSERT INTO crop VALUES (104,  'tobacco');
INSERT INTO crop VALUES (200,  'rice');
INSERT INTO crop VALUES (300,  'barley');
INSERT INTO crop VALUES (301,  'wheat');
INSERT INTO crop VALUES (1000, 'corn');
INSERT INTO crop VALUES (2000, 'grass');
INSERT INTO crop VALUES (3000, 'cacao');


INSERT INTO units VALUES ('pub_ID',       '-',             'Index of publication in table "publication"');
INSERT INTO units VALUES ('longitude',    'degrees east',  'position of measurement');
INSERT INTO units VALUES ('latitude',     'degrees north', 'position of measurement');
INSERT INTO units VALUES ('sdate',        '-',             'starting date of measurement');
INSERT INTO units VALUES ('edate',        '-',             'ending date of measurement');
INSERT INTO units VALUES ('cultiv',       '-',             'anthropogenically influenced (fertilizer, irrigation, liming, ...)');
INSERT INTO units VALUES ('modis_ID',     '-',             'ID of MODIS ecosystem in table "ecosys_modis"');
INSERT INTO units VALUES ('yl_ID',        '-',             'ID of YL95 ecosystem in table "ecosys_yl"');
INSERT INTO units VALUES ('kp_ID',        '-',             'ID of the Koeppen main climate in table "koeppen_main"');
INSERT INTO units VALUES ('NO_emis',      'ng m^-2 s^-1',  'mean measured NO emission flux');
INSERT INTO units VALUES ('NO_emis_SD',   'ng m^-2 s^-1',  'standard deviation of measured NO emission flux');
INSERT INTO units VALUES ('N2O_emis',     'ng m^-2 s^-1',  'mean measured N2O emission flux');
INSERT INTO units VALUES ('sand',         '%',             'soil fraction of sand');
INSERT INTO units VALUES ('silt',         '%',             'soil fraction of silt');
INSERT INTO units VALUES ('clay',         '%',             'soil fraction of clay');
INSERT INTO units VALUES ('C_org',        '%',             'mass fraction of organic carbon');
INSERT INTO units VALUES ('N_org',        '%',             'mass fraction of organic nitrogen');
INSERT INTO units VALUES ('extr_NO3',     'µg g^-1',       'extractable nitrate');
INSERT INTO units VALUES ('extr_NH4',     'µg g^-1',       'extractable ammonium');
INSERT INTO units VALUES ('extr_anorg_N', 'µg g^-1',       'extractable anorganic nitrogen');
INSERT INTO units VALUES ('pH',           '-',             'measured in H2O as well as in KCl-solution');
INSERT INTO units VALUES ('bd',           'g cm^-3',       'bulk density');
INSERT INTO units VALUES ('N_rate',       'kg ha^-1',      'amount of applied fertilizer');
INSERT INTO units VALUES ('f_loss_rate',  '%',             'fraction of fertilizer lost as NO');
INSERT INTO units VALUES ('N_deposition', 'kg ha^-1',      'atmospheric deposition of N species');

INSERT INTO ecosys_modis (name) VALUES ('water');
INSERT INTO ecosys_modis (name) VALUES ('evergreen needleleaf forest');
INSERT INTO ecosys_modis (name) VALUES ('evergreen broadleaf forest');
INSERT INTO ecosys_modis (name) VALUES ('deciduous needleleaf forest');
INSERT INTO ecosys_modis (name) VALUES ('deciduous broadleaf forest');
INSERT INTO ecosys_modis (name) VALUES ('mixed forest');
INSERT INTO ecosys_modis (name) VALUES ('closed shrubland');
INSERT INTO ecosys_modis (name) VALUES ('open shrubland');
INSERT INTO ecosys_modis (name) VALUES ('woody savannas');
INSERT INTO ecosys_modis (name) VALUES ('savannas');
INSERT INTO ecosys_modis (name) VALUES ('grasslands');
INSERT INTO ecosys_modis (name) VALUES ('permanent wetlands');
INSERT INTO ecosys_modis (name) VALUES ('croplands');
INSERT INTO ecosys_modis (name) VALUES ('urban and built-up');
INSERT INTO ecosys_modis (name) VALUES ('cropland/natural vegetation mosaic');
INSERT INTO ecosys_modis (name) VALUES ('snow and ice');
INSERT INTO ecosys_modis (name) VALUES ('barren or sparsely vegetated');
INSERT INTO ecosys_modis (name) VALUES ('unclassified');

INSERT INTO ecosys_yl (name) VALUES ('water');
INSERT INTO ecosys_yl (name) VALUES ('ice');
INSERT INTO ecosys_yl (name) VALUES ('desert');
INSERT INTO ecosys_yl (name) VALUES ('shrubland');
INSERT INTO ecosys_yl (name) VALUES ('tundra');
INSERT INTO ecosys_yl (name) VALUES ('grassland');
INSERT INTO ecosys_yl (name) VALUES ('woodland');
INSERT INTO ecosys_yl (name) VALUES ('decidous forest');
INSERT INTO ecosys_yl (name) VALUES ('coniferous forest');
INSERT INTO ecosys_yl (name) VALUES ('dry decidous forest');
INSERT INTO ecosys_yl (name) VALUES ('rainforest');
INSERT INTO ecosys_yl (name) VALUES ('agriculture');

INSERT INTO koeppen_main (letter, name) VALUES ('A', 'equatorial');
INSERT INTO koeppen_main (letter, name) VALUES ('B', 'arid');
INSERT INTO koeppen_main (letter, name) VALUES ('C', 'warm temperate');
INSERT INTO koeppen_main (letter, name) VALUES ('D', 'snow');
INSERT INTO koeppen_main (letter, name) VALUES ('E', 'polar');

